<?php 
/**
 * Transaksi_sipin Page Controller
 * @category  Controller
 */
class Transaksi_sipinController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "transaksi_sipin";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("idbayar", 
			"tahun", 
			"nis", 
			"nama", 
			"kelas", 
			"status", 
			"bayar", 
			"jenisbayar", 
			"via_transfer", 
			"nama_bank_ewallet", 
			"norek_noewallet", 
			"atas_nama", 
			"tgl", 
			"bukti", 
			"ket");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				transaksi_sipin.idbayar LIKE ? OR 
				transaksi_sipin.tahun LIKE ? OR 
				transaksi_sipin.nis LIKE ? OR 
				transaksi_sipin.nama LIKE ? OR 
				transaksi_sipin.kelas LIKE ? OR 
				transaksi_sipin.status LIKE ? OR 
				transaksi_sipin.bayar LIKE ? OR 
				transaksi_sipin.jenisbayar LIKE ? OR 
				transaksi_sipin.via_transfer LIKE ? OR 
				transaksi_sipin.nama_bank_ewallet LIKE ? OR 
				transaksi_sipin.norek_noewallet LIKE ? OR 
				transaksi_sipin.atas_nama LIKE ? OR 
				transaksi_sipin.tgl LIKE ? OR 
				transaksi_sipin.bukti LIKE ? OR 
				transaksi_sipin.ket LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "transaksi_sipin/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("transaksi_sipin.idbayar", ORDER_TYPE);
		}
		$db->where("transaksi_sipin.nis", get_active_user('user') );
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Transaksi Sipin";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		$this->render_view("transaksi_sipin/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("idbayar", 
			"tahun", 
			"nis", 
			"nama", 
			"kelas", 
			"status", 
			"bayar", 
			"jenisbayar", 
			"via_transfer", 
			"nama_bank_ewallet", 
			"norek_noewallet", 
			"atas_nama", 
			"tgl", 
			"bukti", 
			"ket");
		$db->where("transaksi_sipin.nis", get_active_user('user') );
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("transaksi_sipin.idbayar", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Transaksi Sipin";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("transaksi_sipin/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("tahun","nis","nama","kelas","status","jenisbayar","via_transfer","nama_bank_ewallet","norek_noewallet","atas_nama","bayar","tgl","bukti","ket");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'tahun' => 'required',
				'nis' => 'required',
				'nama' => 'required',
				'kelas' => 'required',
				'status' => 'required',
				'jenisbayar' => 'required',
				'via_transfer' => 'required',
				'nama_bank_ewallet' => 'required',
				'norek_noewallet' => 'required',
				'atas_nama' => 'required',
				'bayar' => 'required|numeric',
				'tgl' => 'required',
				'bukti' => 'required',
				'ket' => 'required',
			);
			$this->sanitize_array = array(
				'tahun' => 'sanitize_string',
				'nis' => 'sanitize_string',
				'nama' => 'sanitize_string',
				'kelas' => 'sanitize_string',
				'status' => 'sanitize_string',
				'jenisbayar' => 'sanitize_string',
				'via_transfer' => 'sanitize_string',
				'nama_bank_ewallet' => 'sanitize_string',
				'norek_noewallet' => 'sanitize_string',
				'atas_nama' => 'sanitize_string',
				'bayar' => 'sanitize_string',
				'tgl' => 'sanitize_string',
				'bukti' => 'sanitize_string',
				'ket' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("transaksi_sipin");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Transaksi Sipin";
		$this->render_view("transaksi_sipin/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("idbayar","tahun","nis","nama","kelas","status","jenisbayar","via_transfer","nama_bank_ewallet","norek_noewallet","atas_nama","bayar","tgl","bukti","ket");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'tahun' => 'required',
				'nis' => 'required',
				'nama' => 'required',
				'kelas' => 'required',
				'status' => 'required',
				'jenisbayar' => 'required',
				'via_transfer' => 'required',
				'nama_bank_ewallet' => 'required',
				'norek_noewallet' => 'required',
				'atas_nama' => 'required',
				'bayar' => 'required|numeric',
				'tgl' => 'required',
				'bukti' => 'required',
				'ket' => 'required',
			);
			$this->sanitize_array = array(
				'tahun' => 'sanitize_string',
				'nis' => 'sanitize_string',
				'nama' => 'sanitize_string',
				'kelas' => 'sanitize_string',
				'status' => 'sanitize_string',
				'jenisbayar' => 'sanitize_string',
				'via_transfer' => 'sanitize_string',
				'nama_bank_ewallet' => 'sanitize_string',
				'norek_noewallet' => 'sanitize_string',
				'atas_nama' => 'sanitize_string',
				'bayar' => 'sanitize_string',
				'tgl' => 'sanitize_string',
				'bukti' => 'sanitize_string',
				'ket' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
		$db->where("transaksi_sipin.nis", get_active_user('user') );
				$db->where("transaksi_sipin.idbayar", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("transaksi_sipin");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("transaksi_sipin");
					}
				}
			}
		}
		$db->where("transaksi_sipin.nis", get_active_user('user') );$db->where("transaksi_sipin.idbayar", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Transaksi Sipin";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("transaksi_sipin/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("idbayar","tahun","nis","nama","kelas","status","jenisbayar","via_transfer","nama_bank_ewallet","norek_noewallet","atas_nama","bayar","tgl","bukti","ket");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'tahun' => 'required',
				'nis' => 'required',
				'nama' => 'required',
				'kelas' => 'required',
				'status' => 'required',
				'jenisbayar' => 'required',
				'via_transfer' => 'required',
				'nama_bank_ewallet' => 'required',
				'norek_noewallet' => 'required',
				'atas_nama' => 'required',
				'bayar' => 'required|numeric',
				'tgl' => 'required',
				'bukti' => 'required',
				'ket' => 'required',
			);
			$this->sanitize_array = array(
				'tahun' => 'sanitize_string',
				'nis' => 'sanitize_string',
				'nama' => 'sanitize_string',
				'kelas' => 'sanitize_string',
				'status' => 'sanitize_string',
				'jenisbayar' => 'sanitize_string',
				'via_transfer' => 'sanitize_string',
				'nama_bank_ewallet' => 'sanitize_string',
				'norek_noewallet' => 'sanitize_string',
				'atas_nama' => 'sanitize_string',
				'bayar' => 'sanitize_string',
				'tgl' => 'sanitize_string',
				'bukti' => 'sanitize_string',
				'ket' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
		$db->where("transaksi_sipin.nis", get_active_user('user') );
				$db->where("transaksi_sipin.idbayar", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("transaksi_sipin.idbayar", $arr_rec_id, "in");
		$db->where("transaksi_sipin.nis", get_active_user('user') );
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("transaksi_sipin");
	}
}
